package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseBlueprintsResponse(
    blueprints: Option[
      Iterable[zio.aws.lightsail.model.RelationalDatabaseBlueprint]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse = {
    import GetRelationalDatabaseBlueprintsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
      .builder()
      .optionallyWith(
        blueprints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blueprints)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseBlueprintsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse =
      zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse(
        blueprints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextPageToken.map(value => value)
      )
    def blueprints: Option[
      List[zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly]
    ]
    def nextPageToken: Option[String]
    def getBlueprints: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly
    ]] = AwsError.unwrapOptionField("blueprints", blueprints)
    def getNextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly {
    override val blueprints: Option[
      List[zio.aws.lightsail.model.RelationalDatabaseBlueprint.ReadOnly]
    ] = scala
      .Option(impl.blueprints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.RelationalDatabaseBlueprint.wrap(item)
        }.toList
      )
    override val nextPageToken: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBlueprintsResponse
  ): zio.aws.lightsail.model.GetRelationalDatabaseBlueprintsResponse.ReadOnly =
    new Wrapper(impl)
}
