package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseBundlesRequest(
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest = {
    import GetRelationalDatabaseBundlesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseBundlesRequest.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseBundlesRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseBundlesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseBundlesRequest =
      zio.aws.lightsail.model
        .GetRelationalDatabaseBundlesRequest(pageToken.map(value => value))
    def pageToken: Option[String]
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseBundlesRequest.ReadOnly {
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesRequest
  ): zio.aws.lightsail.model.GetRelationalDatabaseBundlesRequest.ReadOnly =
    new Wrapper(impl)
}
