package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{Integer, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseEventsRequest(
    relationalDatabaseName: ResourceName,
    durationInMinutes: Option[Integer] = None,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest = {
    import GetRelationalDatabaseEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .optionallyWith(durationInMinutes.map(value => value: java.lang.Integer))(
        _.durationInMinutes
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseEventsRequest.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseEventsRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetRelationalDatabaseEventsRequest =
      zio.aws.lightsail.model.GetRelationalDatabaseEventsRequest(
        relationalDatabaseName,
        durationInMinutes.map(value => value),
        pageToken.map(value => value)
      )
    def relationalDatabaseName: ResourceName
    def durationInMinutes: Option[Integer]
    def pageToken: Option[String]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getDurationInMinutes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("durationInMinutes", durationInMinutes)
    def getPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseEventsRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val durationInMinutes: Option[Integer] =
      scala.Option(impl.durationInMinutes()).map(value => value: Integer)
    override val pageToken: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseEventsRequest
  ): zio.aws.lightsail.model.GetRelationalDatabaseEventsRequest.ReadOnly =
    new Wrapper(impl)
}
