package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseLogEventsResponse(
    resourceLogEvents: Option[Iterable[zio.aws.lightsail.model.LogEvent]] =
      None,
    nextBackwardToken: Option[String] = None,
    nextForwardToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse = {
    import GetRelationalDatabaseLogEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse
      .builder()
      .optionallyWith(
        resourceLogEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceLogEvents)
      .optionallyWith(nextBackwardToken.map(value => value: java.lang.String))(
        _.nextBackwardToken
      )
      .optionallyWith(nextForwardToken.map(value => value: java.lang.String))(
        _.nextForwardToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseLogEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse =
      zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse(
        resourceLogEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextBackwardToken.map(value => value),
        nextForwardToken.map(value => value)
      )
    def resourceLogEvents
        : Option[List[zio.aws.lightsail.model.LogEvent.ReadOnly]]
    def nextBackwardToken: Option[String]
    def nextForwardToken: Option[String]
    def getResourceLogEvents
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.LogEvent.ReadOnly]] =
      AwsError.unwrapOptionField("resourceLogEvents", resourceLogEvents)
    def getNextBackwardToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextBackwardToken", nextBackwardToken)
    def getNextForwardToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextForwardToken", nextForwardToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly {
    override val resourceLogEvents
        : Option[List[zio.aws.lightsail.model.LogEvent.ReadOnly]] = scala
      .Option(impl.resourceLogEvents())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.LogEvent.wrap(item)
        }.toList
      )
    override val nextBackwardToken: Option[String] =
      scala.Option(impl.nextBackwardToken()).map(value => value: String)
    override val nextForwardToken: Option[String] =
      scala.Option(impl.nextForwardToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogEventsResponse
  ): zio.aws.lightsail.model.GetRelationalDatabaseLogEventsResponse.ReadOnly =
    new Wrapper(impl)
}
