package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseLogStreamsResponse(
    logStreams: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse = {
    import GetRelationalDatabaseLogStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse
      .builder()
      .optionallyWith(
        logStreams.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.logStreams)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseLogStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsResponse =
      zio.aws.lightsail.model
        .GetRelationalDatabaseLogStreamsResponse(logStreams.map(value => value))
    def logStreams: Option[List[String]]
    def getLogStreams: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("logStreams", logStreams)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly {
    override val logStreams: Option[List[String]] = scala
      .Option(impl.logStreams())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseLogStreamsResponse
  ): zio.aws.lightsail.model.GetRelationalDatabaseLogStreamsResponse.ReadOnly =
    new Wrapper(impl)
}
