package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{IsoDate, SensitiveString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseMasterUserPasswordResponse(
    masterUserPassword: Option[SensitiveString] = None,
    createdAt: Option[IsoDate] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse = {
    import GetRelationalDatabaseMasterUserPasswordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse
      .builder()
      .optionallyWith(
        masterUserPassword.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.masterUserPassword)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseMasterUserPasswordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse =
      zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse(
        masterUserPassword.map(value => value),
        createdAt.map(value => value)
      )
    def masterUserPassword: Option[SensitiveString]
    def createdAt: Option[IsoDate]
    def getMasterUserPassword: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("masterUserPassword", masterUserPassword)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly {
    override val masterUserPassword: Option[SensitiveString] = scala
      .Option(impl.masterUserPassword())
      .map(value => zio.aws.lightsail.model.primitives.SensitiveString(value))
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse
  ): zio.aws.lightsail.model.GetRelationalDatabaseMasterUserPasswordResponse.ReadOnly =
    new Wrapper(impl)
}
