package zio.aws.lightsail.model
import java.time.Instant
import zio.aws.core.BuilderHelper
import zio.ZIO
import zio.aws.lightsail.model.primitives.{IsoDate, MetricPeriod, ResourceName}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseMetricDataRequest(
    relationalDatabaseName: ResourceName,
    metricName: zio.aws.lightsail.model.RelationalDatabaseMetricName,
    period: MetricPeriod,
    startTime: IsoDate,
    endTime: IsoDate,
    unit: zio.aws.lightsail.model.MetricUnit,
    statistics: Iterable[zio.aws.lightsail.model.MetricStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest = {
    import GetRelationalDatabaseMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .metricName(metricName.unwrap)
      .period(MetricPeriod.unwrap(period): Integer)
      .startTime(IsoDate.unwrap(startTime): Instant)
      .endTime(IsoDate.unwrap(endTime): Instant)
      .unit(unit.unwrap)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseMetricDataRequest.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseMetricDataRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseMetricDataRequest =
      zio.aws.lightsail.model.GetRelationalDatabaseMetricDataRequest(
        relationalDatabaseName,
        metricName,
        period,
        startTime,
        endTime,
        unit,
        statistics
      )
    def relationalDatabaseName: ResourceName
    def metricName: zio.aws.lightsail.model.RelationalDatabaseMetricName
    def period: MetricPeriod
    def startTime: IsoDate
    def endTime: IsoDate
    def unit: zio.aws.lightsail.model.MetricUnit
    def statistics: List[zio.aws.lightsail.model.MetricStatistic]
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
    def getMetricName: ZIO[
      Any,
      Nothing,
      zio.aws.lightsail.model.RelationalDatabaseMetricName
    ] = ZIO.succeed(metricName)
    def getPeriod: ZIO[Any, Nothing, MetricPeriod] = ZIO.succeed(period)
    def getStartTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(endTime)
    def getUnit: ZIO[Any, Nothing, zio.aws.lightsail.model.MetricUnit] =
      ZIO.succeed(unit)
    def getStatistics
        : ZIO[Any, Nothing, List[zio.aws.lightsail.model.MetricStatistic]] =
      ZIO.succeed(statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseMetricDataRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
    override val metricName
        : zio.aws.lightsail.model.RelationalDatabaseMetricName =
      zio.aws.lightsail.model.RelationalDatabaseMetricName
        .wrap(impl.metricName())
    override val period: MetricPeriod =
      zio.aws.lightsail.model.primitives.MetricPeriod(impl.period())
    override val startTime: IsoDate =
      zio.aws.lightsail.model.primitives.IsoDate(impl.startTime())
    override val endTime: IsoDate =
      zio.aws.lightsail.model.primitives.IsoDate(impl.endTime())
    override val unit: zio.aws.lightsail.model.MetricUnit =
      zio.aws.lightsail.model.MetricUnit.wrap(impl.unit())
    override val statistics: List[zio.aws.lightsail.model.MetricStatistic] =
      impl
        .statistics()
        .asScala
        .map { item =>
          zio.aws.lightsail.model.MetricStatistic.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMetricDataRequest
  ): zio.aws.lightsail.model.GetRelationalDatabaseMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
