package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseSnapshotRequest(
    relationalDatabaseSnapshotName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest = {
    import GetRelationalDatabaseSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest
      .builder()
      .relationalDatabaseSnapshotName(
        ResourceName.unwrap(relationalDatabaseSnapshotName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.GetRelationalDatabaseSnapshotRequest.ReadOnly =
    zio.aws.lightsail.model.GetRelationalDatabaseSnapshotRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.GetRelationalDatabaseSnapshotRequest =
      zio.aws.lightsail.model
        .GetRelationalDatabaseSnapshotRequest(relationalDatabaseSnapshotName)
    def relationalDatabaseSnapshotName: ResourceName
    def getRelationalDatabaseSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseSnapshotName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest
  ) extends zio.aws.lightsail.model.GetRelationalDatabaseSnapshotRequest.ReadOnly {
    override val relationalDatabaseSnapshotName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseSnapshotName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseSnapshotRequest
  ): zio.aws.lightsail.model.GetRelationalDatabaseSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
