package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetStaticIpRequest(staticIpName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest = {
    import GetStaticIpRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest
      .builder()
      .staticIpName(ResourceName.unwrap(staticIpName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.GetStaticIpRequest.ReadOnly =
    zio.aws.lightsail.model.GetStaticIpRequest.wrap(buildAwsValue())
}
object GetStaticIpRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.GetStaticIpRequest =
      zio.aws.lightsail.model.GetStaticIpRequest(staticIpName)
    def staticIpName: ResourceName
    def getStaticIpName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(staticIpName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest
  ) extends zio.aws.lightsail.model.GetStaticIpRequest.ReadOnly {
    override val staticIpName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.staticIpName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetStaticIpRequest
  ): zio.aws.lightsail.model.GetStaticIpRequest.ReadOnly = new Wrapper(impl)
}
