package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{Base64, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ImportKeyPairRequest(
    keyPairName: ResourceName,
    publicKeyBase64: Base64
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest = {
    import ImportKeyPairRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest
      .builder()
      .keyPairName(ResourceName.unwrap(keyPairName): java.lang.String)
      .publicKeyBase64(Base64.unwrap(publicKeyBase64): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.ImportKeyPairRequest.ReadOnly =
    zio.aws.lightsail.model.ImportKeyPairRequest.wrap(buildAwsValue())
}
object ImportKeyPairRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.ImportKeyPairRequest =
      zio.aws.lightsail.model.ImportKeyPairRequest(keyPairName, publicKeyBase64)
    def keyPairName: ResourceName
    def publicKeyBase64: Base64
    def getKeyPairName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(keyPairName)
    def getPublicKeyBase64: ZIO[Any, Nothing, Base64] =
      ZIO.succeed(publicKeyBase64)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest
  ) extends zio.aws.lightsail.model.ImportKeyPairRequest.ReadOnly {
    override val keyPairName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.keyPairName())
    override val publicKeyBase64: Base64 =
      zio.aws.lightsail.model.primitives.Base64(impl.publicKeyBase64())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ImportKeyPairRequest
  ): zio.aws.lightsail.model.ImportKeyPairRequest.ReadOnly = new Wrapper(impl)
}
