package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  Ipv6Address,
  IpAddress,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Instance(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None,
    blueprintId: Option[NonEmptyString] = None,
    blueprintName: Option[NonEmptyString] = None,
    bundleId: Option[NonEmptyString] = None,
    addOns: Option[Iterable[zio.aws.lightsail.model.AddOn]] = None,
    isStaticIp: Option[Boolean] = None,
    privateIpAddress: Option[IpAddress] = None,
    publicIpAddress: Option[IpAddress] = None,
    ipv6Addresses: Option[Iterable[Ipv6Address]] = None,
    ipAddressType: Option[zio.aws.lightsail.model.IpAddressType] = None,
    hardware: Option[zio.aws.lightsail.model.InstanceHardware] = None,
    networking: Option[zio.aws.lightsail.model.InstanceNetworking] = None,
    state: Option[zio.aws.lightsail.model.InstanceState] = None,
    username: Option[NonEmptyString] = None,
    sshKeyName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Instance = {
    import Instance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Instance
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        blueprintId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.blueprintId)
      .optionallyWith(
        blueprintName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.blueprintName)
      .optionallyWith(
        bundleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.bundleId)
      .optionallyWith(
        addOns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addOns)
      .optionallyWith(isStaticIp.map(value => value: java.lang.Boolean))(
        _.isStaticIp
      )
      .optionallyWith(
        privateIpAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.privateIpAddress)
      .optionallyWith(
        publicIpAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.publicIpAddress)
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            Ipv6Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(hardware.map(value => value.buildAwsValue()))(_.hardware)
      .optionallyWith(networking.map(value => value.buildAwsValue()))(
        _.networking
      )
      .optionallyWith(state.map(value => value.buildAwsValue()))(_.state)
      .optionallyWith(
        username.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.username)
      .optionallyWith(
        sshKeyName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.sshKeyName)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Instance.ReadOnly =
    zio.aws.lightsail.model.Instance.wrap(buildAwsValue())
}
object Instance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Instance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Instance =
      zio.aws.lightsail.model.Instance(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blueprintId.map(value => value),
        blueprintName.map(value => value),
        bundleId.map(value => value),
        addOns.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        isStaticIp.map(value => value),
        privateIpAddress.map(value => value),
        publicIpAddress.map(value => value),
        ipv6Addresses.map(value => value),
        ipAddressType.map(value => value),
        hardware.map(value => value.asEditable),
        networking.map(value => value.asEditable),
        state.map(value => value.asEditable),
        username.map(value => value),
        sshKeyName.map(value => value)
      )
    def name: Option[ResourceName]
    def arn: Option[NonEmptyString]
    def supportCode: Option[String]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def blueprintId: Option[NonEmptyString]
    def blueprintName: Option[NonEmptyString]
    def bundleId: Option[NonEmptyString]
    def addOns: Option[List[zio.aws.lightsail.model.AddOn.ReadOnly]]
    def isStaticIp: Option[Boolean]
    def privateIpAddress: Option[IpAddress]
    def publicIpAddress: Option[IpAddress]
    def ipv6Addresses: Option[List[Ipv6Address]]
    def ipAddressType: Option[zio.aws.lightsail.model.IpAddressType]
    def hardware: Option[zio.aws.lightsail.model.InstanceHardware.ReadOnly]
    def networking: Option[zio.aws.lightsail.model.InstanceNetworking.ReadOnly]
    def state: Option[zio.aws.lightsail.model.InstanceState.ReadOnly]
    def username: Option[NonEmptyString]
    def sshKeyName: Option[ResourceName]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getBlueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("blueprintId", blueprintId)
    def getBlueprintName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("blueprintName", blueprintName)
    def getBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getAddOns
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.AddOn.ReadOnly]] =
      AwsError.unwrapOptionField("addOns", addOns)
    def getIsStaticIp: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isStaticIp", isStaticIp)
    def getPrivateIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPublicIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("publicIpAddress", publicIpAddress)
    def getIpv6Addresses: ZIO[Any, AwsError, List[Ipv6Address]] =
      AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getHardware: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.InstanceHardware.ReadOnly
    ] = AwsError.unwrapOptionField("hardware", hardware)
    def getNetworking: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.InstanceNetworking.ReadOnly
    ] = AwsError.unwrapOptionField("networking", networking)
    def getState
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceState.ReadOnly] =
      AwsError.unwrapOptionField("state", state)
    def getUsername: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("username", username)
    def getSshKeyName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("sshKeyName", sshKeyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Instance
  ) extends zio.aws.lightsail.model.Instance.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override val blueprintId: Option[NonEmptyString] = scala
      .Option(impl.blueprintId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val blueprintName: Option[NonEmptyString] = scala
      .Option(impl.blueprintName())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val bundleId: Option[NonEmptyString] = scala
      .Option(impl.bundleId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val addOns: Option[List[zio.aws.lightsail.model.AddOn.ReadOnly]] =
      scala
        .Option(impl.addOns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AddOn.wrap(item)
          }.toList
        )
    override val isStaticIp: Option[Boolean] =
      scala.Option(impl.isStaticIp()).map(value => value: Boolean)
    override val privateIpAddress: Option[IpAddress] = scala
      .Option(impl.privateIpAddress())
      .map(value => zio.aws.lightsail.model.primitives.IpAddress(value))
    override val publicIpAddress: Option[IpAddress] = scala
      .Option(impl.publicIpAddress())
      .map(value => zio.aws.lightsail.model.primitives.IpAddress(value))
    override val ipv6Addresses: Option[List[Ipv6Address]] = scala
      .Option(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.primitives.Ipv6Address(item)
        }.toList
      )
    override val ipAddressType: Option[zio.aws.lightsail.model.IpAddressType] =
      scala
        .Option(impl.ipAddressType())
        .map(value => zio.aws.lightsail.model.IpAddressType.wrap(value))
    override val hardware
        : Option[zio.aws.lightsail.model.InstanceHardware.ReadOnly] = scala
      .Option(impl.hardware())
      .map(value => zio.aws.lightsail.model.InstanceHardware.wrap(value))
    override val networking
        : Option[zio.aws.lightsail.model.InstanceNetworking.ReadOnly] = scala
      .Option(impl.networking())
      .map(value => zio.aws.lightsail.model.InstanceNetworking.wrap(value))
    override val state: Option[zio.aws.lightsail.model.InstanceState.ReadOnly] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.lightsail.model.InstanceState.wrap(value))
    override val username: Option[NonEmptyString] = scala
      .Option(impl.username())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val sshKeyName: Option[ResourceName] = scala
      .Option(impl.sshKeyName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Instance
  ): zio.aws.lightsail.model.Instance.ReadOnly = new Wrapper(impl)
}
