package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{ResourceName, IpAddress, IsoDate}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class InstanceAccessDetails(
    certKey: Option[String] = None,
    expiresAt: Option[IsoDate] = None,
    ipAddress: Option[IpAddress] = None,
    password: Option[String] = None,
    passwordData: Option[zio.aws.lightsail.model.PasswordData] = None,
    privateKey: Option[String] = None,
    protocol: Option[zio.aws.lightsail.model.InstanceAccessProtocol] = None,
    instanceName: Option[ResourceName] = None,
    username: Option[String] = None,
    hostKeys: Option[Iterable[zio.aws.lightsail.model.HostKeyAttributes]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails = {
    import InstanceAccessDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
      .builder()
      .optionallyWith(certKey.map(value => value: java.lang.String))(_.certKey)
      .optionallyWith(expiresAt.map(value => IsoDate.unwrap(value): Instant))(
        _.expiresAt
      )
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(password.map(value => value: java.lang.String))(
        _.password
      )
      .optionallyWith(passwordData.map(value => value.buildAwsValue()))(
        _.passwordData
      )
      .optionallyWith(privateKey.map(value => value: java.lang.String))(
        _.privateKey
      )
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        instanceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.instanceName)
      .optionallyWith(username.map(value => value: java.lang.String))(
        _.username
      )
      .optionallyWith(
        hostKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hostKeys)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstanceAccessDetails.ReadOnly =
    zio.aws.lightsail.model.InstanceAccessDetails.wrap(buildAwsValue())
}
object InstanceAccessDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstanceAccessDetails =
      zio.aws.lightsail.model.InstanceAccessDetails(
        certKey.map(value => value),
        expiresAt.map(value => value),
        ipAddress.map(value => value),
        password.map(value => value),
        passwordData.map(value => value.asEditable),
        privateKey.map(value => value),
        protocol.map(value => value),
        instanceName.map(value => value),
        username.map(value => value),
        hostKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certKey: Option[String]
    def expiresAt: Option[IsoDate]
    def ipAddress: Option[IpAddress]
    def password: Option[String]
    def passwordData: Option[zio.aws.lightsail.model.PasswordData.ReadOnly]
    def privateKey: Option[String]
    def protocol: Option[zio.aws.lightsail.model.InstanceAccessProtocol]
    def instanceName: Option[ResourceName]
    def username: Option[String]
    def hostKeys
        : Option[List[zio.aws.lightsail.model.HostKeyAttributes.ReadOnly]]
    def getCertKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("certKey", certKey)
    def getExpiresAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("expiresAt", expiresAt)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getPassword: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("password", password)
    def getPasswordData
        : ZIO[Any, AwsError, zio.aws.lightsail.model.PasswordData.ReadOnly] =
      AwsError.unwrapOptionField("passwordData", passwordData)
    def getPrivateKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateKey", privateKey)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceAccessProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("instanceName", instanceName)
    def getUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("username", username)
    def getHostKeys: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.HostKeyAttributes.ReadOnly
    ]] = AwsError.unwrapOptionField("hostKeys", hostKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
  ) extends zio.aws.lightsail.model.InstanceAccessDetails.ReadOnly {
    override val certKey: Option[String] =
      scala.Option(impl.certKey()).map(value => value: String)
    override val expiresAt: Option[IsoDate] = scala
      .Option(impl.expiresAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val ipAddress: Option[IpAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.lightsail.model.primitives.IpAddress(value))
    override val password: Option[String] =
      scala.Option(impl.password()).map(value => value: String)
    override val passwordData
        : Option[zio.aws.lightsail.model.PasswordData.ReadOnly] = scala
      .Option(impl.passwordData())
      .map(value => zio.aws.lightsail.model.PasswordData.wrap(value))
    override val privateKey: Option[String] =
      scala.Option(impl.privateKey()).map(value => value: String)
    override val protocol
        : Option[zio.aws.lightsail.model.InstanceAccessProtocol] = scala
      .Option(impl.protocol())
      .map(value => zio.aws.lightsail.model.InstanceAccessProtocol.wrap(value))
    override val instanceName: Option[ResourceName] = scala
      .Option(impl.instanceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val username: Option[String] =
      scala.Option(impl.username()).map(value => value: String)
    override val hostKeys
        : Option[List[zio.aws.lightsail.model.HostKeyAttributes.ReadOnly]] =
      scala
        .Option(impl.hostKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.HostKeyAttributes.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceAccessDetails
  ): zio.aws.lightsail.model.InstanceAccessDetails.ReadOnly = new Wrapper(impl)
}
