package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait InstanceHealthState {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.InstanceHealthState
}
object InstanceHealthState {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.InstanceHealthState
  ): zio.aws.lightsail.model.InstanceHealthState = value match {
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.INITIAL =>
      val r = initial
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.HEALTHY =>
      val r = healthy
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNHEALTHY =>
      val r = unhealthy
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNUSED =>
      val r = unused
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.DRAINING =>
      val r = draining
      r
    case software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNAVAILABLE =>
      val r = unavailable
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.InstanceHealthState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthState =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNKNOWN_TO_SDK_VERSION
  }
  case object initial extends zio.aws.lightsail.model.InstanceHealthState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthState =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthState.INITIAL
  }
  case object healthy extends zio.aws.lightsail.model.InstanceHealthState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthState =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthState.HEALTHY
  }
  case object unhealthy extends zio.aws.lightsail.model.InstanceHealthState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthState =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNHEALTHY
  }
  case object unused extends zio.aws.lightsail.model.InstanceHealthState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthState =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNUSED
  }
  case object draining extends zio.aws.lightsail.model.InstanceHealthState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthState =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthState.DRAINING
  }
  case object unavailable extends zio.aws.lightsail.model.InstanceHealthState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.InstanceHealthState =
      software.amazon.awssdk.services.lightsail.model.InstanceHealthState.UNAVAILABLE
  }
}
