package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceHealthSummary(
    instanceName: Option[ResourceName] = None,
    instanceHealth: Option[zio.aws.lightsail.model.InstanceHealthState] = None,
    instanceHealthReason: Option[zio.aws.lightsail.model.InstanceHealthReason] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary = {
    import InstanceHealthSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary
      .builder()
      .optionallyWith(
        instanceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.instanceName)
      .optionallyWith(instanceHealth.map(value => value.unwrap))(
        _.instanceHealth
      )
      .optionallyWith(instanceHealthReason.map(value => value.unwrap))(
        _.instanceHealthReason
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstanceHealthSummary.ReadOnly =
    zio.aws.lightsail.model.InstanceHealthSummary.wrap(buildAwsValue())
}
object InstanceHealthSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstanceHealthSummary =
      zio.aws.lightsail.model.InstanceHealthSummary(
        instanceName.map(value => value),
        instanceHealth.map(value => value),
        instanceHealthReason.map(value => value)
      )
    def instanceName: Option[ResourceName]
    def instanceHealth: Option[zio.aws.lightsail.model.InstanceHealthState]
    def instanceHealthReason
        : Option[zio.aws.lightsail.model.InstanceHealthReason]
    def getInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("instanceName", instanceName)
    def getInstanceHealth
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceHealthState] =
      AwsError.unwrapOptionField("instanceHealth", instanceHealth)
    def getInstanceHealthReason
        : ZIO[Any, AwsError, zio.aws.lightsail.model.InstanceHealthReason] =
      AwsError.unwrapOptionField("instanceHealthReason", instanceHealthReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary
  ) extends zio.aws.lightsail.model.InstanceHealthSummary.ReadOnly {
    override val instanceName: Option[ResourceName] = scala
      .Option(impl.instanceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val instanceHealth
        : Option[zio.aws.lightsail.model.InstanceHealthState] = scala
      .Option(impl.instanceHealth())
      .map(value => zio.aws.lightsail.model.InstanceHealthState.wrap(value))
    override val instanceHealthReason
        : Option[zio.aws.lightsail.model.InstanceHealthReason] = scala
      .Option(impl.instanceHealthReason())
      .map(value => zio.aws.lightsail.model.InstanceHealthReason.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceHealthSummary
  ): zio.aws.lightsail.model.InstanceHealthSummary.ReadOnly = new Wrapper(impl)
}
