package zio.aws.lightsail.model
import java.lang.Integer
import zio.aws.lightsail.model.primitives.Port
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstancePortInfo(
    fromPort: Option[Port] = None,
    toPort: Option[Port] = None,
    protocol: Option[zio.aws.lightsail.model.NetworkProtocol] = None,
    accessFrom: Option[String] = None,
    accessType: Option[zio.aws.lightsail.model.PortAccessType] = None,
    commonName: Option[String] = None,
    accessDirection: Option[zio.aws.lightsail.model.AccessDirection] = None,
    cidrs: Option[Iterable[String]] = None,
    ipv6Cidrs: Option[Iterable[String]] = None,
    cidrListAliases: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstancePortInfo = {
    import InstancePortInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstancePortInfo
      .builder()
      .optionallyWith(fromPort.map(value => Port.unwrap(value): Integer))(
        _.fromPort
      )
      .optionallyWith(toPort.map(value => Port.unwrap(value): Integer))(
        _.toPort
      )
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(accessFrom.map(value => value: java.lang.String))(
        _.accessFrom
      )
      .optionallyWith(accessType.map(value => value.unwrap))(_.accessType)
      .optionallyWith(commonName.map(value => value: java.lang.String))(
        _.commonName
      )
      .optionallyWith(accessDirection.map(value => value.unwrap))(
        _.accessDirection
      )
      .optionallyWith(
        cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrs)
      .optionallyWith(
        ipv6Cidrs.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.ipv6Cidrs)
      .optionallyWith(
        cidrListAliases.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.cidrListAliases)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstancePortInfo.ReadOnly =
    zio.aws.lightsail.model.InstancePortInfo.wrap(buildAwsValue())
}
object InstancePortInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstancePortInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstancePortInfo =
      zio.aws.lightsail.model.InstancePortInfo(
        fromPort.map(value => value),
        toPort.map(value => value),
        protocol.map(value => value),
        accessFrom.map(value => value),
        accessType.map(value => value),
        commonName.map(value => value),
        accessDirection.map(value => value),
        cidrs.map(value => value),
        ipv6Cidrs.map(value => value),
        cidrListAliases.map(value => value)
      )
    def fromPort: Option[Port]
    def toPort: Option[Port]
    def protocol: Option[zio.aws.lightsail.model.NetworkProtocol]
    def accessFrom: Option[String]
    def accessType: Option[zio.aws.lightsail.model.PortAccessType]
    def commonName: Option[String]
    def accessDirection: Option[zio.aws.lightsail.model.AccessDirection]
    def cidrs: Option[List[String]]
    def ipv6Cidrs: Option[List[String]]
    def cidrListAliases: Option[List[String]]
    def getFromPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("fromPort", fromPort)
    def getToPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("toPort", toPort)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.lightsail.model.NetworkProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
    def getAccessFrom: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accessFrom", accessFrom)
    def getAccessType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.PortAccessType] =
      AwsError.unwrapOptionField("accessType", accessType)
    def getCommonName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("commonName", commonName)
    def getAccessDirection
        : ZIO[Any, AwsError, zio.aws.lightsail.model.AccessDirection] =
      AwsError.unwrapOptionField("accessDirection", accessDirection)
    def getCidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrs", cidrs)
    def getIpv6Cidrs: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("ipv6Cidrs", ipv6Cidrs)
    def getCidrListAliases: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("cidrListAliases", cidrListAliases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstancePortInfo
  ) extends zio.aws.lightsail.model.InstancePortInfo.ReadOnly {
    override val fromPort: Option[Port] = scala
      .Option(impl.fromPort())
      .map(value => zio.aws.lightsail.model.primitives.Port(value))
    override val toPort: Option[Port] = scala
      .Option(impl.toPort())
      .map(value => zio.aws.lightsail.model.primitives.Port(value))
    override val protocol: Option[zio.aws.lightsail.model.NetworkProtocol] =
      scala
        .Option(impl.protocol())
        .map(value => zio.aws.lightsail.model.NetworkProtocol.wrap(value))
    override val accessFrom: Option[String] =
      scala.Option(impl.accessFrom()).map(value => value: String)
    override val accessType: Option[zio.aws.lightsail.model.PortAccessType] =
      scala
        .Option(impl.accessType())
        .map(value => zio.aws.lightsail.model.PortAccessType.wrap(value))
    override val commonName: Option[String] =
      scala.Option(impl.commonName()).map(value => value: String)
    override val accessDirection
        : Option[zio.aws.lightsail.model.AccessDirection] = scala
      .Option(impl.accessDirection())
      .map(value => zio.aws.lightsail.model.AccessDirection.wrap(value))
    override val cidrs: Option[List[String]] = scala
      .Option(impl.cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val ipv6Cidrs: Option[List[String]] = scala
      .Option(impl.ipv6Cidrs())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val cidrListAliases: Option[List[String]] = scala
      .Option(impl.cidrListAliases())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstancePortInfo
  ): zio.aws.lightsail.model.InstancePortInfo.ReadOnly = new Wrapper(impl)
}
