package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceSnapshotInfo(
    fromBundleId: Option[NonEmptyString] = None,
    fromBlueprintId: Option[NonEmptyString] = None,
    fromDiskInfo: Option[Iterable[zio.aws.lightsail.model.DiskInfo]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo = {
    import InstanceSnapshotInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
      .builder()
      .optionallyWith(
        fromBundleId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fromBundleId)
      .optionallyWith(
        fromBlueprintId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.fromBlueprintId)
      .optionallyWith(
        fromDiskInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fromDiskInfo)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly =
    zio.aws.lightsail.model.InstanceSnapshotInfo.wrap(buildAwsValue())
}
object InstanceSnapshotInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.InstanceSnapshotInfo =
      zio.aws.lightsail.model.InstanceSnapshotInfo(
        fromBundleId.map(value => value),
        fromBlueprintId.map(value => value),
        fromDiskInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def fromBundleId: Option[NonEmptyString]
    def fromBlueprintId: Option[NonEmptyString]
    def fromDiskInfo: Option[List[zio.aws.lightsail.model.DiskInfo.ReadOnly]]
    def getFromBundleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromBundleId", fromBundleId)
    def getFromBlueprintId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromBlueprintId", fromBlueprintId)
    def getFromDiskInfo
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.DiskInfo.ReadOnly]] =
      AwsError.unwrapOptionField("fromDiskInfo", fromDiskInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
  ) extends zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly {
    override val fromBundleId: Option[NonEmptyString] = scala
      .Option(impl.fromBundleId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val fromBlueprintId: Option[NonEmptyString] = scala
      .Option(impl.fromBlueprintId())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val fromDiskInfo
        : Option[List[zio.aws.lightsail.model.DiskInfo.ReadOnly]] = scala
      .Option(impl.fromDiskInfo())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.DiskInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceSnapshotInfo
  ): zio.aws.lightsail.model.InstanceSnapshotInfo.ReadOnly = new Wrapper(impl)
}
