package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class IsVpcPeeredResponse(isPeered: Option[Boolean] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse = {
    import IsVpcPeeredResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse
      .builder()
      .optionallyWith(isPeered.map(value => value: java.lang.Boolean))(
        _.isPeered
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.IsVpcPeeredResponse.ReadOnly =
    zio.aws.lightsail.model.IsVpcPeeredResponse.wrap(buildAwsValue())
}
object IsVpcPeeredResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.IsVpcPeeredResponse =
      zio.aws.lightsail.model.IsVpcPeeredResponse(isPeered.map(value => value))
    def isPeered: Option[Boolean]
    def getIsPeered: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPeered", isPeered)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse
  ) extends zio.aws.lightsail.model.IsVpcPeeredResponse.ReadOnly {
    override val isPeered: Option[Boolean] =
      scala.Option(impl.isPeered()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.IsVpcPeeredResponse
  ): zio.aws.lightsail.model.IsVpcPeeredResponse.ReadOnly = new Wrapper(impl)
}
