package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class LightsailDistribution(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    alternativeDomainNames: Option[Iterable[String]] = None,
    status: Option[String] = None,
    isEnabled: Option[Boolean] = None,
    domainName: Option[String] = None,
    bundleId: Option[String] = None,
    certificateName: Option[ResourceName] = None,
    origin: Option[zio.aws.lightsail.model.Origin] = None,
    originPublicDNS: Option[String] = None,
    defaultCacheBehavior: Option[zio.aws.lightsail.model.CacheBehavior] = None,
    cacheBehaviorSettings: Option[zio.aws.lightsail.model.CacheSettings] = None,
    cacheBehaviors: Option[
      Iterable[zio.aws.lightsail.model.CacheBehaviorPerPath]
    ] = None,
    ableToUpdateBundle: Option[Boolean] = None,
    ipAddressType: Option[zio.aws.lightsail.model.IpAddressType] = None,
    tags: Option[Iterable[zio.aws.lightsail.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LightsailDistribution = {
    import LightsailDistribution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LightsailDistribution
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        alternativeDomainNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.alternativeDomainNames)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(isEnabled.map(value => value: java.lang.Boolean))(
        _.isEnabled
      )
      .optionallyWith(domainName.map(value => value: java.lang.String))(
        _.domainName
      )
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(
        certificateName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.certificateName)
      .optionallyWith(origin.map(value => value.buildAwsValue()))(_.origin)
      .optionallyWith(originPublicDNS.map(value => value: java.lang.String))(
        _.originPublicDNS
      )
      .optionallyWith(defaultCacheBehavior.map(value => value.buildAwsValue()))(
        _.defaultCacheBehavior
      )
      .optionallyWith(
        cacheBehaviorSettings.map(value => value.buildAwsValue())
      )(_.cacheBehaviorSettings)
      .optionallyWith(
        cacheBehaviors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cacheBehaviors)
      .optionallyWith(
        ableToUpdateBundle.map(value => value: java.lang.Boolean)
      )(_.ableToUpdateBundle)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.LightsailDistribution.ReadOnly =
    zio.aws.lightsail.model.LightsailDistribution.wrap(buildAwsValue())
}
object LightsailDistribution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LightsailDistribution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.LightsailDistribution =
      zio.aws.lightsail.model.LightsailDistribution(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        alternativeDomainNames.map(value => value),
        status.map(value => value),
        isEnabled.map(value => value),
        domainName.map(value => value),
        bundleId.map(value => value),
        certificateName.map(value => value),
        origin.map(value => value.asEditable),
        originPublicDNS.map(value => value),
        defaultCacheBehavior.map(value => value.asEditable),
        cacheBehaviorSettings.map(value => value.asEditable),
        cacheBehaviors.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ableToUpdateBundle.map(value => value),
        ipAddressType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[ResourceName]
    def arn: Option[NonEmptyString]
    def supportCode: Option[String]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def alternativeDomainNames: Option[List[String]]
    def status: Option[String]
    def isEnabled: Option[Boolean]
    def domainName: Option[String]
    def bundleId: Option[String]
    def certificateName: Option[ResourceName]
    def origin: Option[zio.aws.lightsail.model.Origin.ReadOnly]
    def originPublicDNS: Option[String]
    def defaultCacheBehavior
        : Option[zio.aws.lightsail.model.CacheBehavior.ReadOnly]
    def cacheBehaviorSettings
        : Option[zio.aws.lightsail.model.CacheSettings.ReadOnly]
    def cacheBehaviors
        : Option[List[zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly]]
    def ableToUpdateBundle: Option[Boolean]
    def ipAddressType: Option[zio.aws.lightsail.model.IpAddressType]
    def tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getAlternativeDomainNames: ZIO[Any, AwsError, List[String]] = AwsError
      .unwrapOptionField("alternativeDomainNames", alternativeDomainNames)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getIsEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEnabled", isEnabled)
    def getDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getBundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getCertificateName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("certificateName", certificateName)
    def getOrigin: ZIO[Any, AwsError, zio.aws.lightsail.model.Origin.ReadOnly] =
      AwsError.unwrapOptionField("origin", origin)
    def getOriginPublicDNS: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("originPublicDNS", originPublicDNS)
    def getDefaultCacheBehavior
        : ZIO[Any, AwsError, zio.aws.lightsail.model.CacheBehavior.ReadOnly] =
      AwsError.unwrapOptionField("defaultCacheBehavior", defaultCacheBehavior)
    def getCacheBehaviorSettings
        : ZIO[Any, AwsError, zio.aws.lightsail.model.CacheSettings.ReadOnly] =
      AwsError.unwrapOptionField("cacheBehaviorSettings", cacheBehaviorSettings)
    def getCacheBehaviors: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly
    ]] = AwsError.unwrapOptionField("cacheBehaviors", cacheBehaviors)
    def getAbleToUpdateBundle: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("ableToUpdateBundle", ableToUpdateBundle)
    def getIpAddressType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.IpAddressType] =
      AwsError.unwrapOptionField("ipAddressType", ipAddressType)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LightsailDistribution
  ) extends zio.aws.lightsail.model.LightsailDistribution.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val alternativeDomainNames: Option[List[String]] = scala
      .Option(impl.alternativeDomainNames())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val isEnabled: Option[Boolean] =
      scala.Option(impl.isEnabled()).map(value => value: Boolean)
    override val domainName: Option[String] =
      scala.Option(impl.domainName()).map(value => value: String)
    override val bundleId: Option[String] =
      scala.Option(impl.bundleId()).map(value => value: String)
    override val certificateName: Option[ResourceName] = scala
      .Option(impl.certificateName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val origin: Option[zio.aws.lightsail.model.Origin.ReadOnly] = scala
      .Option(impl.origin())
      .map(value => zio.aws.lightsail.model.Origin.wrap(value))
    override val originPublicDNS: Option[String] =
      scala.Option(impl.originPublicDNS()).map(value => value: String)
    override val defaultCacheBehavior
        : Option[zio.aws.lightsail.model.CacheBehavior.ReadOnly] = scala
      .Option(impl.defaultCacheBehavior())
      .map(value => zio.aws.lightsail.model.CacheBehavior.wrap(value))
    override val cacheBehaviorSettings
        : Option[zio.aws.lightsail.model.CacheSettings.ReadOnly] = scala
      .Option(impl.cacheBehaviorSettings())
      .map(value => zio.aws.lightsail.model.CacheSettings.wrap(value))
    override val cacheBehaviors
        : Option[List[zio.aws.lightsail.model.CacheBehaviorPerPath.ReadOnly]] =
      scala
        .Option(impl.cacheBehaviors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.CacheBehaviorPerPath.wrap(item)
          }.toList
        )
    override val ableToUpdateBundle: Option[Boolean] =
      scala.Option(impl.ableToUpdateBundle()).map(value => value: Boolean)
    override val ipAddressType: Option[zio.aws.lightsail.model.IpAddressType] =
      scala
        .Option(impl.ipAddressType())
        .map(value => zio.aws.lightsail.model.IpAddressType.wrap(value))
    override val tags: Option[List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LightsailDistribution
  ): zio.aws.lightsail.model.LightsailDistribution.ReadOnly = new Wrapper(impl)
}
