package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait LoadBalancerAttributeName {
  def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName
}
object LoadBalancerAttributeName {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName
  ): zio.aws.lightsail.model.LoadBalancerAttributeName = value match {
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName.HEALTH_CHECK_PATH =>
      val r = HealthCheckPath
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName.SESSION_STICKINESS_ENABLED =>
      val r = SessionStickinessEnabled
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName.SESSION_STICKINESS_LB_COOKIE_DURATION_SECONDS =>
      val r = SessionStickiness_LB_CookieDurationSeconds
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.LoadBalancerAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName.UNKNOWN_TO_SDK_VERSION
  }
  case object HealthCheckPath
      extends zio.aws.lightsail.model.LoadBalancerAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName.HEALTH_CHECK_PATH
  }
  case object SessionStickinessEnabled
      extends zio.aws.lightsail.model.LoadBalancerAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName.SESSION_STICKINESS_ENABLED
  }
  case object SessionStickiness_LB_CookieDurationSeconds
      extends zio.aws.lightsail.model.LoadBalancerAttributeName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerAttributeName.SESSION_STICKINESS_LB_COOKIE_DURATION_SECONDS
  }
}
