package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait LoadBalancerState {
  def unwrap: software.amazon.awssdk.services.lightsail.model.LoadBalancerState
}
object LoadBalancerState {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.LoadBalancerState
  ): zio.aws.lightsail.model.LoadBalancerState = value match {
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.PROVISIONING =>
      val r = provisioning
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.ACTIVE_IMPAIRED =>
      val r = active_impaired
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.lightsail.model.LoadBalancerState.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.LoadBalancerState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerState =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerState.UNKNOWN_TO_SDK_VERSION
  }
  case object active extends zio.aws.lightsail.model.LoadBalancerState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerState =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerState.ACTIVE
  }
  case object provisioning extends zio.aws.lightsail.model.LoadBalancerState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerState =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerState.PROVISIONING
  }
  case object active_impaired
      extends zio.aws.lightsail.model.LoadBalancerState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerState =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerState.ACTIVE_IMPAIRED
  }
  case object failed extends zio.aws.lightsail.model.LoadBalancerState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerState =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerState.FAILED
  }
  case object unknown extends zio.aws.lightsail.model.LoadBalancerState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.LoadBalancerState =
      software.amazon.awssdk.services.lightsail.model.LoadBalancerState.UNKNOWN
  }
}
