package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoadBalancerTlsCertificateDomainValidationOption(
    domainName: Option[DomainName] = None,
    validationStatus: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption = {
    import LoadBalancerTlsCertificateDomainValidationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(validationStatus.map(value => value.unwrap))(
        _.validationStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly =
    zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
      .wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateDomainValidationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption =
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption(
        domainName.map(value => value),
        validationStatus.map(value => value)
      )
    def domainName: Option[DomainName]
    def validationStatus
        : Option[zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getValidationStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = AwsError.unwrapOptionField("validationStatus", validationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
  ) extends zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly {
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.lightsail.model.primitives.DomainName(value))
    override val validationStatus: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
    ] = scala
      .Option(impl.validationStatus())
      .map(value =>
        zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
  ): zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly =
    new Wrapper(impl)
}
