package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoadBalancerTlsCertificateRenewalSummary(
    renewalStatus: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalStatus
    ] = None,
    domainValidationOptions: Option[Iterable[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary = {
    import LoadBalancerTlsCertificateRenewalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
      .builder()
      .optionallyWith(renewalStatus.map(value => value.unwrap))(_.renewalStatus)
      .optionallyWith(
        domainValidationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationOptions)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly =
    zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
      .wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateRenewalSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary =
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary(
        renewalStatus.map(value => value),
        domainValidationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def renewalStatus: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalStatus
    ]
    def domainValidationOptions: Option[List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly
    ]]
    def getRenewalStatus: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalStatus
    ] = AwsError.unwrapOptionField("renewalStatus", renewalStatus)
    def getDomainValidationOptions: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationOptions",
      domainValidationOptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
  ) extends zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly {
    override val renewalStatus: Option[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalStatus
    ] = scala
      .Option(impl.renewalStatus())
      .map(value =>
        zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalStatus
          .wrap(value)
      )
    override val domainValidationOptions: Option[List[
      zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly
    ]] = scala
      .Option(impl.domainValidationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
  ): zio.aws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly =
    new Wrapper(impl)
}
