package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoadBalancerTlsCertificateSummary(
    name: Option[ResourceName] = None,
    isAttached: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary = {
    import LoadBalancerTlsCertificateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(isAttached.map(value => value: java.lang.Boolean))(
        _.isAttached
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly =
    zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary
      .wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary =
      zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary(
        name.map(value => value),
        isAttached.map(value => value)
      )
    def name: Option[ResourceName]
    def isAttached: Option[Boolean]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getIsAttached: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttached", isAttached)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary
  ) extends zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val isAttached: Option[Boolean] =
      scala.Option(impl.isAttached()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateSummary
  ): zio.aws.lightsail.model.LoadBalancerTlsCertificateSummary.ReadOnly =
    new Wrapper(impl)
}
