package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class MetricDatapoint(
    average: Option[Double] = None,
    maximum: Option[Double] = None,
    minimum: Option[Double] = None,
    sampleCount: Option[Double] = None,
    sum: Option[Double] = None,
    timestamp: Option[Timestamp] = None,
    unit: Option[zio.aws.lightsail.model.MetricUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.MetricDatapoint = {
    import MetricDatapoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.MetricDatapoint
      .builder()
      .optionallyWith(average.map(value => value: java.lang.Double))(_.average)
      .optionallyWith(maximum.map(value => value: java.lang.Double))(_.maximum)
      .optionallyWith(minimum.map(value => value: java.lang.Double))(_.minimum)
      .optionallyWith(sampleCount.map(value => value: java.lang.Double))(
        _.sampleCount
      )
      .optionallyWith(sum.map(value => value: java.lang.Double))(_.sum)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.MetricDatapoint.ReadOnly =
    zio.aws.lightsail.model.MetricDatapoint.wrap(buildAwsValue())
}
object MetricDatapoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.MetricDatapoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.MetricDatapoint =
      zio.aws.lightsail.model.MetricDatapoint(
        average.map(value => value),
        maximum.map(value => value),
        minimum.map(value => value),
        sampleCount.map(value => value),
        sum.map(value => value),
        timestamp.map(value => value),
        unit.map(value => value)
      )
    def average: Option[Double]
    def maximum: Option[Double]
    def minimum: Option[Double]
    def sampleCount: Option[Double]
    def sum: Option[Double]
    def timestamp: Option[Timestamp]
    def unit: Option[zio.aws.lightsail.model.MetricUnit]
    def getAverage: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("average", average)
    def getMaximum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getMinimum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("minimum", minimum)
    def getSampleCount: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("sampleCount", sampleCount)
    def getSum: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("sum", sum)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getUnit: ZIO[Any, AwsError, zio.aws.lightsail.model.MetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.MetricDatapoint
  ) extends zio.aws.lightsail.model.MetricDatapoint.ReadOnly {
    override val average: Option[Double] =
      scala.Option(impl.average()).map(value => value: Double)
    override val maximum: Option[Double] =
      scala.Option(impl.maximum()).map(value => value: Double)
    override val minimum: Option[Double] =
      scala.Option(impl.minimum()).map(value => value: Double)
    override val sampleCount: Option[Double] =
      scala.Option(impl.sampleCount()).map(value => value: Double)
    override val sum: Option[Double] =
      scala.Option(impl.sum()).map(value => value: Double)
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.lightsail.model.primitives.Timestamp(value))
    override val unit: Option[zio.aws.lightsail.model.MetricUnit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.lightsail.model.MetricUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.MetricDatapoint
  ): zio.aws.lightsail.model.MetricDatapoint.ReadOnly = new Wrapper(impl)
}
