package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait MetricStatistic {
  def unwrap: software.amazon.awssdk.services.lightsail.model.MetricStatistic
}
object MetricStatistic {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.MetricStatistic
  ): zio.aws.lightsail.model.MetricStatistic = value match {
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.MINIMUM =>
      val r = Minimum
      r
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.MAXIMUM =>
      val r = Maximum
      r
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.SUM =>
      val r = Sum
      r
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.AVERAGE =>
      val r = Average
      r
    case software.amazon.awssdk.services.lightsail.model.MetricStatistic.SAMPLE_COUNT =>
      val r = SampleCount
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.MetricStatistic =
      software.amazon.awssdk.services.lightsail.model.MetricStatistic.UNKNOWN_TO_SDK_VERSION
  }
  case object Minimum extends zio.aws.lightsail.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.MetricStatistic =
      software.amazon.awssdk.services.lightsail.model.MetricStatistic.MINIMUM
  }
  case object Maximum extends zio.aws.lightsail.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.MetricStatistic =
      software.amazon.awssdk.services.lightsail.model.MetricStatistic.MAXIMUM
  }
  case object Sum extends zio.aws.lightsail.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.MetricStatistic =
      software.amazon.awssdk.services.lightsail.model.MetricStatistic.SUM
  }
  case object Average extends zio.aws.lightsail.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.MetricStatistic =
      software.amazon.awssdk.services.lightsail.model.MetricStatistic.AVERAGE
  }
  case object SampleCount extends zio.aws.lightsail.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.MetricStatistic =
      software.amazon.awssdk.services.lightsail.model.MetricStatistic.SAMPLE_COUNT
  }
}
