package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MonthlyTransfer(gbPerMonthAllocated: Option[Integer] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.MonthlyTransfer = {
    import MonthlyTransfer.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
      .builder()
      .optionallyWith(
        gbPerMonthAllocated.map(value => value: java.lang.Integer)
      )(_.gbPerMonthAllocated)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.MonthlyTransfer.ReadOnly =
    zio.aws.lightsail.model.MonthlyTransfer.wrap(buildAwsValue())
}
object MonthlyTransfer {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.MonthlyTransfer =
      zio.aws.lightsail.model
        .MonthlyTransfer(gbPerMonthAllocated.map(value => value))
    def gbPerMonthAllocated: Option[Integer]
    def getGbPerMonthAllocated: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("gbPerMonthAllocated", gbPerMonthAllocated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
  ) extends zio.aws.lightsail.model.MonthlyTransfer.ReadOnly {
    override val gbPerMonthAllocated: Option[Integer] =
      scala.Option(impl.gbPerMonthAllocated()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.MonthlyTransfer
  ): zio.aws.lightsail.model.MonthlyTransfer.ReadOnly = new Wrapper(impl)
}
