package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OpenInstancePublicPortsRequest(
    portInfo: zio.aws.lightsail.model.PortInfo,
    instanceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest = {
    import OpenInstancePublicPortsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest
      .builder()
      .portInfo(portInfo.buildAwsValue())
      .instanceName(ResourceName.unwrap(instanceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.OpenInstancePublicPortsRequest.ReadOnly =
    zio.aws.lightsail.model.OpenInstancePublicPortsRequest.wrap(buildAwsValue())
}
object OpenInstancePublicPortsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.OpenInstancePublicPortsRequest =
      zio.aws.lightsail.model
        .OpenInstancePublicPortsRequest(portInfo.asEditable, instanceName)
    def portInfo: zio.aws.lightsail.model.PortInfo.ReadOnly
    def instanceName: ResourceName
    def getPortInfo
        : ZIO[Any, Nothing, zio.aws.lightsail.model.PortInfo.ReadOnly] =
      ZIO.succeed(portInfo)
    def getInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest
  ) extends zio.aws.lightsail.model.OpenInstancePublicPortsRequest.ReadOnly {
    override val portInfo: zio.aws.lightsail.model.PortInfo.ReadOnly =
      zio.aws.lightsail.model.PortInfo.wrap(impl.portInfo())
    override val instanceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.instanceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsRequest
  ): zio.aws.lightsail.model.OpenInstancePublicPortsRequest.ReadOnly =
    new Wrapper(impl)
}
