package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OpenInstancePublicPortsResponse(
    operation: Option[zio.aws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse = {
    import OpenInstancePublicPortsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly =
    zio.aws.lightsail.model.OpenInstancePublicPortsResponse
      .wrap(buildAwsValue())
}
object OpenInstancePublicPortsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.OpenInstancePublicPortsResponse =
      zio.aws.lightsail.model.OpenInstancePublicPortsResponse(
        operation.map(value => value.asEditable)
      )
    def operation: Option[zio.aws.lightsail.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse
  ) extends zio.aws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly {
    override val operation: Option[zio.aws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.OpenInstancePublicPortsResponse
  ): zio.aws.lightsail.model.OpenInstancePublicPortsResponse.ReadOnly =
    new Wrapper(impl)
}
