package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  IsoDate,
  ResourceName,
  NonEmptyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Operation(
    id: Option[NonEmptyString] = None,
    resourceName: Option[ResourceName] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    isTerminal: Option[Boolean] = None,
    operationDetails: Option[String] = None,
    operationType: Option[zio.aws.lightsail.model.OperationType] = None,
    status: Option[zio.aws.lightsail.model.OperationStatus] = None,
    statusChangedAt: Option[IsoDate] = None,
    errorCode: Option[String] = None,
    errorDetails: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Operation = {
    import Operation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Operation
      .builder()
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(isTerminal.map(value => value: java.lang.Boolean))(
        _.isTerminal
      )
      .optionallyWith(operationDetails.map(value => value: java.lang.String))(
        _.operationDetails
      )
      .optionallyWith(operationType.map(value => value.unwrap))(_.operationType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusChangedAt.map(value => IsoDate.unwrap(value): Instant)
      )(_.statusChangedAt)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorDetails.map(value => value: java.lang.String))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Operation.ReadOnly =
    zio.aws.lightsail.model.Operation.wrap(buildAwsValue())
}
object Operation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.Operation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Operation =
      zio.aws.lightsail.model.Operation(
        id.map(value => value),
        resourceName.map(value => value),
        resourceType.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        isTerminal.map(value => value),
        operationDetails.map(value => value),
        operationType.map(value => value),
        status.map(value => value),
        statusChangedAt.map(value => value),
        errorCode.map(value => value),
        errorDetails.map(value => value)
      )
    def id: Option[NonEmptyString]
    def resourceName: Option[ResourceName]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def isTerminal: Option[Boolean]
    def operationDetails: Option[String]
    def operationType: Option[zio.aws.lightsail.model.OperationType]
    def status: Option[zio.aws.lightsail.model.OperationStatus]
    def statusChangedAt: Option[IsoDate]
    def errorCode: Option[String]
    def errorDetails: Option[String]
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getIsTerminal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isTerminal", isTerminal)
    def getOperationDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("operationDetails", operationDetails)
    def getOperationType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.OperationType] =
      AwsError.unwrapOptionField("operationType", operationType)
    def getStatus: ZIO[Any, AwsError, zio.aws.lightsail.model.OperationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusChangedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("statusChangedAt", statusChangedAt)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorDetails: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Operation
  ) extends zio.aws.lightsail.model.Operation.ReadOnly {
    override val id: Option[NonEmptyString] = scala
      .Option(impl.id())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val resourceName: Option[ResourceName] = scala
      .Option(impl.resourceName())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val isTerminal: Option[Boolean] =
      scala.Option(impl.isTerminal()).map(value => value: Boolean)
    override val operationDetails: Option[String] =
      scala.Option(impl.operationDetails()).map(value => value: String)
    override val operationType: Option[zio.aws.lightsail.model.OperationType] =
      scala
        .Option(impl.operationType())
        .map(value => zio.aws.lightsail.model.OperationType.wrap(value))
    override val status: Option[zio.aws.lightsail.model.OperationStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.lightsail.model.OperationStatus.wrap(value))
    override val statusChangedAt: Option[IsoDate] = scala
      .Option(impl.statusChangedAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override val errorDetails: Option[String] =
      scala.Option(impl.errorDetails()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Operation
  ): zio.aws.lightsail.model.Operation.ReadOnly = new Wrapper(impl)
}
