package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Origin(
    name: Option[ResourceName] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    regionName: Option[zio.aws.lightsail.model.RegionName] = None,
    protocolPolicy: Option[zio.aws.lightsail.model.OriginProtocolPolicyEnum] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Origin = {
    import Origin.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Origin
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(regionName.map(value => value.unwrap))(_.regionName)
      .optionallyWith(protocolPolicy.map(value => value.unwrap))(
        _.protocolPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Origin.ReadOnly =
    zio.aws.lightsail.model.Origin.wrap(buildAwsValue())
}
object Origin {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Origin] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Origin =
      zio.aws.lightsail.model.Origin(
        name.map(value => value),
        resourceType.map(value => value),
        regionName.map(value => value),
        protocolPolicy.map(value => value)
      )
    def name: Option[ResourceName]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def regionName: Option[zio.aws.lightsail.model.RegionName]
    def protocolPolicy: Option[zio.aws.lightsail.model.OriginProtocolPolicyEnum]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getRegionName: ZIO[Any, AwsError, zio.aws.lightsail.model.RegionName] =
      AwsError.unwrapOptionField("regionName", regionName)
    def getProtocolPolicy
        : ZIO[Any, AwsError, zio.aws.lightsail.model.OriginProtocolPolicyEnum] =
      AwsError.unwrapOptionField("protocolPolicy", protocolPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Origin
  ) extends zio.aws.lightsail.model.Origin.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val regionName: Option[zio.aws.lightsail.model.RegionName] = scala
      .Option(impl.regionName())
      .map(value => zio.aws.lightsail.model.RegionName.wrap(value))
    override val protocolPolicy
        : Option[zio.aws.lightsail.model.OriginProtocolPolicyEnum] = scala
      .Option(impl.protocolPolicy())
      .map(value =>
        zio.aws.lightsail.model.OriginProtocolPolicyEnum.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Origin
  ): zio.aws.lightsail.model.Origin.ReadOnly = new Wrapper(impl)
}
