package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait PortAccessType {
  def unwrap: software.amazon.awssdk.services.lightsail.model.PortAccessType
}
object PortAccessType {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.PortAccessType
  ): zio.aws.lightsail.model.PortAccessType = value match {
    case software.amazon.awssdk.services.lightsail.model.PortAccessType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.PortAccessType.PUBLIC =>
      val r = Public
      r
    case software.amazon.awssdk.services.lightsail.model.PortAccessType.PRIVATE =>
      val r = Private
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.PortAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PortAccessType =
      software.amazon.awssdk.services.lightsail.model.PortAccessType.UNKNOWN_TO_SDK_VERSION
  }
  case object Public extends zio.aws.lightsail.model.PortAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PortAccessType =
      software.amazon.awssdk.services.lightsail.model.PortAccessType.PUBLIC
  }
  case object Private extends zio.aws.lightsail.model.PortAccessType {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PortAccessType =
      software.amazon.awssdk.services.lightsail.model.PortAccessType.PRIVATE
  }
}
