package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait PortState {
  def unwrap: software.amazon.awssdk.services.lightsail.model.PortState
}
object PortState {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.PortState
  ): zio.aws.lightsail.model.PortState = value match {
    case software.amazon.awssdk.services.lightsail.model.PortState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.PortState.OPEN =>
      val r = open
      r
    case software.amazon.awssdk.services.lightsail.model.PortState.CLOSED =>
      val r = closed
      r
  }
  case object unknownToSdkVersion extends zio.aws.lightsail.model.PortState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PortState =
      software.amazon.awssdk.services.lightsail.model.PortState.UNKNOWN_TO_SDK_VERSION
  }
  case object open extends zio.aws.lightsail.model.PortState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PortState =
      software.amazon.awssdk.services.lightsail.model.PortState.OPEN
  }
  case object closed extends zio.aws.lightsail.model.PortState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.PortState =
      software.amazon.awssdk.services.lightsail.model.PortState.CLOSED
  }
}
