package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutInstancePublicPortsResponse(
    operation: Option[zio.aws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse = {
    import PutInstancePublicPortsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse
      .builder()
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly =
    zio.aws.lightsail.model.PutInstancePublicPortsResponse.wrap(buildAwsValue())
}
object PutInstancePublicPortsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.PutInstancePublicPortsResponse =
      zio.aws.lightsail.model.PutInstancePublicPortsResponse(
        operation.map(value => value.asEditable)
      )
    def operation: Option[zio.aws.lightsail.model.Operation.ReadOnly]
    def getOperation
        : ZIO[Any, AwsError, zio.aws.lightsail.model.Operation.ReadOnly] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse
  ) extends zio.aws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly {
    override val operation: Option[zio.aws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value => zio.aws.lightsail.model.Operation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.PutInstancePublicPortsResponse
  ): zio.aws.lightsail.model.PutInstancePublicPortsResponse.ReadOnly =
    new Wrapper(impl)
}
