package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RebootRelationalDatabaseRequest(
    relationalDatabaseName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest = {
    import RebootRelationalDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest
      .builder()
      .relationalDatabaseName(
        ResourceName.unwrap(relationalDatabaseName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.RebootRelationalDatabaseRequest.ReadOnly =
    zio.aws.lightsail.model.RebootRelationalDatabaseRequest
      .wrap(buildAwsValue())
}
object RebootRelationalDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RebootRelationalDatabaseRequest =
      zio.aws.lightsail.model
        .RebootRelationalDatabaseRequest(relationalDatabaseName)
    def relationalDatabaseName: ResourceName
    def getRelationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest
  ) extends zio.aws.lightsail.model.RebootRelationalDatabaseRequest.ReadOnly {
    override val relationalDatabaseName: ResourceName =
      zio.aws.lightsail.model.primitives
        .ResourceName(impl.relationalDatabaseName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RebootRelationalDatabaseRequest
  ): zio.aws.lightsail.model.RebootRelationalDatabaseRequest.ReadOnly =
    new Wrapper(impl)
}
