package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Region(
    continentCode: Option[String] = None,
    description: Option[String] = None,
    displayName: Option[String] = None,
    name: Option[zio.aws.lightsail.model.RegionName] = None,
    availabilityZones: Option[
      Iterable[zio.aws.lightsail.model.AvailabilityZone]
    ] = None,
    relationalDatabaseAvailabilityZones: Option[
      Iterable[zio.aws.lightsail.model.AvailabilityZone]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.Region = {
    import Region.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.Region
      .builder()
      .optionallyWith(continentCode.map(value => value: java.lang.String))(
        _.continentCode
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        relationalDatabaseAvailabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationalDatabaseAvailabilityZones)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.Region.ReadOnly =
    zio.aws.lightsail.model.Region.wrap(buildAwsValue())
}
object Region {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.Region] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.Region =
      zio.aws.lightsail.model.Region(
        continentCode.map(value => value),
        description.map(value => value),
        displayName.map(value => value),
        name.map(value => value),
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relationalDatabaseAvailabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def continentCode: Option[String]
    def description: Option[String]
    def displayName: Option[String]
    def name: Option[zio.aws.lightsail.model.RegionName]
    def availabilityZones
        : Option[List[zio.aws.lightsail.model.AvailabilityZone.ReadOnly]]
    def relationalDatabaseAvailabilityZones
        : Option[List[zio.aws.lightsail.model.AvailabilityZone.ReadOnly]]
    def getContinentCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("continentCode", continentCode)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDisplayName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getName: ZIO[Any, AwsError, zio.aws.lightsail.model.RegionName] =
      AwsError.unwrapOptionField("name", name)
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getRelationalDatabaseAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.lightsail.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relationalDatabaseAvailabilityZones",
      relationalDatabaseAvailabilityZones
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.Region
  ) extends zio.aws.lightsail.model.Region.ReadOnly {
    override val continentCode: Option[String] =
      scala.Option(impl.continentCode()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val displayName: Option[String] =
      scala.Option(impl.displayName()).map(value => value: String)
    override val name: Option[zio.aws.lightsail.model.RegionName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.RegionName.wrap(value))
    override val availabilityZones
        : Option[List[zio.aws.lightsail.model.AvailabilityZone.ReadOnly]] =
      scala
        .Option(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AvailabilityZone.wrap(item)
          }.toList
        )
    override val relationalDatabaseAvailabilityZones
        : Option[List[zio.aws.lightsail.model.AvailabilityZone.ReadOnly]] =
      scala
        .Option(impl.relationalDatabaseAvailabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.lightsail.model.AvailabilityZone.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.Region
  ): zio.aws.lightsail.model.Region.ReadOnly = new Wrapper(impl)
}
