package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{ContainerLabel, ContainerServiceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegisterContainerImageRequest(
    serviceName: ContainerServiceName,
    label: ContainerLabel,
    digest: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest = {
    import RegisterContainerImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest
      .builder()
      .serviceName(ContainerServiceName.unwrap(serviceName): java.lang.String)
      .label(ContainerLabel.unwrap(label): java.lang.String)
      .digest(digest: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.RegisterContainerImageRequest.ReadOnly =
    zio.aws.lightsail.model.RegisterContainerImageRequest.wrap(buildAwsValue())
}
object RegisterContainerImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RegisterContainerImageRequest =
      zio.aws.lightsail.model
        .RegisterContainerImageRequest(serviceName, label, digest)
    def serviceName: ContainerServiceName
    def label: ContainerLabel
    def digest: String
    def getServiceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceName)
    def getLabel: ZIO[Any, Nothing, ContainerLabel] = ZIO.succeed(label)
    def getDigest: ZIO[Any, Nothing, String] = ZIO.succeed(digest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest
  ) extends zio.aws.lightsail.model.RegisterContainerImageRequest.ReadOnly {
    override val serviceName: ContainerServiceName =
      zio.aws.lightsail.model.primitives
        .ContainerServiceName(impl.serviceName())
    override val label: ContainerLabel =
      zio.aws.lightsail.model.primitives.ContainerLabel(impl.label())
    override val digest: String = impl.digest(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageRequest
  ): zio.aws.lightsail.model.RegisterContainerImageRequest.ReadOnly =
    new Wrapper(impl)
}
