package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterContainerImageResponse(
    containerImage: Option[zio.aws.lightsail.model.ContainerImage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse = {
    import RegisterContainerImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
      .builder()
      .optionallyWith(containerImage.map(value => value.buildAwsValue()))(
        _.containerImage
      )
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.RegisterContainerImageResponse.ReadOnly =
    zio.aws.lightsail.model.RegisterContainerImageResponse.wrap(buildAwsValue())
}
object RegisterContainerImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RegisterContainerImageResponse =
      zio.aws.lightsail.model.RegisterContainerImageResponse(
        containerImage.map(value => value.asEditable)
      )
    def containerImage: Option[zio.aws.lightsail.model.ContainerImage.ReadOnly]
    def getContainerImage
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ContainerImage.ReadOnly] =
      AwsError.unwrapOptionField("containerImage", containerImage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
  ) extends zio.aws.lightsail.model.RegisterContainerImageResponse.ReadOnly {
    override val containerImage
        : Option[zio.aws.lightsail.model.ContainerImage.ReadOnly] = scala
      .Option(impl.containerImage())
      .map(value => zio.aws.lightsail.model.ContainerImage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RegisterContainerImageResponse
  ): zio.aws.lightsail.model.RegisterContainerImageResponse.ReadOnly =
    new Wrapper(impl)
}
