package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseBundle(
    bundleId: Option[String] = None,
    name: Option[String] = None,
    price: Option[Float] = None,
    ramSizeInGb: Option[Float] = None,
    diskSizeInGb: Option[Integer] = None,
    transferPerMonthInGb: Option[Integer] = None,
    cpuCount: Option[Integer] = None,
    isEncrypted: Option[Boolean] = None,
    isActive: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle = {
    import RelationalDatabaseBundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle
      .builder()
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .optionallyWith(diskSizeInGb.map(value => value: java.lang.Integer))(
        _.diskSizeInGb
      )
      .optionallyWith(
        transferPerMonthInGb.map(value => value: java.lang.Integer)
      )(_.transferPerMonthInGb)
      .optionallyWith(cpuCount.map(value => value: java.lang.Integer))(
        _.cpuCount
      )
      .optionallyWith(isEncrypted.map(value => value: java.lang.Boolean))(
        _.isEncrypted
      )
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabaseBundle.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabaseBundle.wrap(buildAwsValue())
}
object RelationalDatabaseBundle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabaseBundle =
      zio.aws.lightsail.model.RelationalDatabaseBundle(
        bundleId.map(value => value),
        name.map(value => value),
        price.map(value => value),
        ramSizeInGb.map(value => value),
        diskSizeInGb.map(value => value),
        transferPerMonthInGb.map(value => value),
        cpuCount.map(value => value),
        isEncrypted.map(value => value),
        isActive.map(value => value)
      )
    def bundleId: Option[String]
    def name: Option[String]
    def price: Option[Float]
    def ramSizeInGb: Option[Float]
    def diskSizeInGb: Option[Integer]
    def transferPerMonthInGb: Option[Integer]
    def cpuCount: Option[Integer]
    def isEncrypted: Option[Boolean]
    def isActive: Option[Boolean]
    def getBundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bundleId", bundleId)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getPrice: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", price)
    def getRamSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGb)
    def getDiskSizeInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("diskSizeInGb", diskSizeInGb)
    def getTransferPerMonthInGb: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("transferPerMonthInGb", transferPerMonthInGb)
    def getCpuCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpuCount", cpuCount)
    def getIsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEncrypted", isEncrypted)
    def getIsActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle
  ) extends zio.aws.lightsail.model.RelationalDatabaseBundle.ReadOnly {
    override val bundleId: Option[String] =
      scala.Option(impl.bundleId()).map(value => value: String)
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val price: Option[Float] =
      scala.Option(impl.price()).map(value => value: Float)
    override val ramSizeInGb: Option[Float] =
      scala.Option(impl.ramSizeInGb()).map(value => value: Float)
    override val diskSizeInGb: Option[Integer] =
      scala.Option(impl.diskSizeInGb()).map(value => value: Integer)
    override val transferPerMonthInGb: Option[Integer] =
      scala.Option(impl.transferPerMonthInGb()).map(value => value: Integer)
    override val cpuCount: Option[Integer] =
      scala.Option(impl.cpuCount()).map(value => value: Integer)
    override val isEncrypted: Option[Boolean] =
      scala.Option(impl.isEncrypted()).map(value => value: Boolean)
    override val isActive: Option[Boolean] =
      scala.Option(impl.isActive()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseBundle
  ): zio.aws.lightsail.model.RelationalDatabaseBundle.ReadOnly = new Wrapper(
    impl
  )
}
