package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{NonEmptyString, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseEndpoint(
    port: Option[Integer] = None,
    address: Option[NonEmptyString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint = {
    import RelationalDatabaseEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint
      .builder()
      .optionallyWith(port.map(value => value: java.lang.Integer))(_.port)
      .optionallyWith(
        address.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.address)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabaseEndpoint.wrap(buildAwsValue())
}
object RelationalDatabaseEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabaseEndpoint =
      zio.aws.lightsail.model.RelationalDatabaseEndpoint(
        port.map(value => value),
        address.map(value => value)
      )
    def port: Option[Integer]
    def address: Option[NonEmptyString]
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("address", address)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint
  ) extends zio.aws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly {
    override val port: Option[Integer] =
      scala.Option(impl.port()).map(value => value: Integer)
    override val address: Option[NonEmptyString] = scala
      .Option(impl.address())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEndpoint
  ): zio.aws.lightsail.model.RelationalDatabaseEndpoint.ReadOnly = new Wrapper(
    impl
  )
}
