package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait RelationalDatabaseEngine {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine
}
object RelationalDatabaseEngine {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine
  ): zio.aws.lightsail.model.RelationalDatabaseEngine = value match {
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine.MYSQL =>
      val r = mysql
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.RelationalDatabaseEngine {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine.UNKNOWN_TO_SDK_VERSION
  }
  case object mysql extends zio.aws.lightsail.model.RelationalDatabaseEngine {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEngine.MYSQL
  }
}
