package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{IsoDate, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseEvent(
    resource: Option[ResourceName] = None,
    createdAt: Option[IsoDate] = None,
    message: Option[String] = None,
    eventCategories: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent = {
    import RelationalDatabaseEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
      .builder()
      .optionallyWith(
        resource.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resource)
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(
        eventCategories.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.eventCategories)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabaseEvent.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabaseEvent.wrap(buildAwsValue())
}
object RelationalDatabaseEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabaseEvent =
      zio.aws.lightsail.model.RelationalDatabaseEvent(
        resource.map(value => value),
        createdAt.map(value => value),
        message.map(value => value),
        eventCategories.map(value => value)
      )
    def resource: Option[ResourceName]
    def createdAt: Option[IsoDate]
    def message: Option[String]
    def eventCategories: Option[List[String]]
    def getResource: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resource", resource)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
    def getEventCategories: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("eventCategories", eventCategories)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
  ) extends zio.aws.lightsail.model.RelationalDatabaseEvent.ReadOnly {
    override val resource: Option[ResourceName] = scala
      .Option(impl.resource())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
    override val eventCategories: Option[List[String]] = scala
      .Option(impl.eventCategories())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseEvent
  ): zio.aws.lightsail.model.RelationalDatabaseEvent.ReadOnly = new Wrapper(
    impl
  )
}
