package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseParameter(
    allowedValues: Option[String] = None,
    applyMethod: Option[String] = None,
    applyType: Option[String] = None,
    dataType: Option[String] = None,
    description: Option[String] = None,
    isModifiable: Option[Boolean] = None,
    parameterName: Option[String] = None,
    parameterValue: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter = {
    import RelationalDatabaseParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
      .builder()
      .optionallyWith(allowedValues.map(value => value: java.lang.String))(
        _.allowedValues
      )
      .optionallyWith(applyMethod.map(value => value: java.lang.String))(
        _.applyMethod
      )
      .optionallyWith(applyType.map(value => value: java.lang.String))(
        _.applyType
      )
      .optionallyWith(dataType.map(value => value: java.lang.String))(
        _.dataType
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(isModifiable.map(value => value: java.lang.Boolean))(
        _.isModifiable
      )
      .optionallyWith(parameterName.map(value => value: java.lang.String))(
        _.parameterName
      )
      .optionallyWith(parameterValue.map(value => value: java.lang.String))(
        _.parameterValue
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly =
    zio.aws.lightsail.model.RelationalDatabaseParameter.wrap(buildAwsValue())
}
object RelationalDatabaseParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.RelationalDatabaseParameter =
      zio.aws.lightsail.model.RelationalDatabaseParameter(
        allowedValues.map(value => value),
        applyMethod.map(value => value),
        applyType.map(value => value),
        dataType.map(value => value),
        description.map(value => value),
        isModifiable.map(value => value),
        parameterName.map(value => value),
        parameterValue.map(value => value)
      )
    def allowedValues: Option[String]
    def applyMethod: Option[String]
    def applyType: Option[String]
    def dataType: Option[String]
    def description: Option[String]
    def isModifiable: Option[Boolean]
    def parameterName: Option[String]
    def parameterValue: Option[String]
    def getAllowedValues: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("allowedValues", allowedValues)
    def getApplyMethod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyMethod", applyMethod)
    def getApplyType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyType", applyType)
    def getDataType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dataType", dataType)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getIsModifiable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isModifiable", isModifiable)
    def getParameterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterName", parameterName)
    def getParameterValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterValue", parameterValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
  ) extends zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly {
    override val allowedValues: Option[String] =
      scala.Option(impl.allowedValues()).map(value => value: String)
    override val applyMethod: Option[String] =
      scala.Option(impl.applyMethod()).map(value => value: String)
    override val applyType: Option[String] =
      scala.Option(impl.applyType()).map(value => value: String)
    override val dataType: Option[String] =
      scala.Option(impl.dataType()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val isModifiable: Option[Boolean] =
      scala.Option(impl.isModifiable()).map(value => value: Boolean)
    override val parameterName: Option[String] =
      scala.Option(impl.parameterName()).map(value => value: String)
    override val parameterValue: Option[String] =
      scala.Option(impl.parameterValue()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.RelationalDatabaseParameter
  ): zio.aws.lightsail.model.RelationalDatabaseParameter.ReadOnly = new Wrapper(
    impl
  )
}
