package zio.aws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait RelationalDatabasePasswordVersion {
  def unwrap: software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion
}
object RelationalDatabasePasswordVersion {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion
  ): zio.aws.lightsail.model.RelationalDatabasePasswordVersion = value match {
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.CURRENT =>
      val r = CURRENT
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.PREVIOUS =>
      val r = PREVIOUS
      r
    case software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.lightsail.model.RelationalDatabasePasswordVersion {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object CURRENT
      extends zio.aws.lightsail.model.RelationalDatabasePasswordVersion {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.CURRENT
  }
  case object PREVIOUS
      extends zio.aws.lightsail.model.RelationalDatabasePasswordVersion {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.PREVIOUS
  }
  case object PENDING
      extends zio.aws.lightsail.model.RelationalDatabasePasswordVersion {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion =
      software.amazon.awssdk.services.lightsail.model.RelationalDatabasePasswordVersion.PENDING
  }
}
