package zio.aws.lightsail.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SendContactMethodVerificationRequest(
    protocol: zio.aws.lightsail.model.ContactMethodVerificationProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest = {
    import SendContactMethodVerificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest
      .builder()
      .protocol(protocol.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.lightsail.model.SendContactMethodVerificationRequest.ReadOnly =
    zio.aws.lightsail.model.SendContactMethodVerificationRequest
      .wrap(buildAwsValue())
}
object SendContactMethodVerificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.lightsail.model.SendContactMethodVerificationRequest =
      zio.aws.lightsail.model.SendContactMethodVerificationRequest(protocol)
    def protocol: zio.aws.lightsail.model.ContactMethodVerificationProtocol
    def getProtocol: ZIO[
      Any,
      Nothing,
      zio.aws.lightsail.model.ContactMethodVerificationProtocol
    ] = ZIO.succeed(protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest
  ) extends zio.aws.lightsail.model.SendContactMethodVerificationRequest.ReadOnly {
    override val protocol
        : zio.aws.lightsail.model.ContactMethodVerificationProtocol =
      zio.aws.lightsail.model.ContactMethodVerificationProtocol
        .wrap(impl.protocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.SendContactMethodVerificationRequest
  ): zio.aws.lightsail.model.SendContactMethodVerificationRequest.ReadOnly =
    new Wrapper(impl)
}
