package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{
  IpAddress,
  IsoDate,
  NonEmptyString,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class StaticIp(
    name: Option[ResourceName] = None,
    arn: Option[NonEmptyString] = None,
    supportCode: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[zio.aws.lightsail.model.ResourceLocation] = None,
    resourceType: Option[zio.aws.lightsail.model.ResourceType] = None,
    ipAddress: Option[IpAddress] = None,
    attachedTo: Option[ResourceName] = None,
    isAttached: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.StaticIp = {
    import StaticIp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.StaticIp
      .builder()
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(supportCode.map(value => value: java.lang.String))(
        _.supportCode
      )
      .optionallyWith(createdAt.map(value => IsoDate.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(
        attachedTo.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.attachedTo)
      .optionallyWith(isAttached.map(value => value: java.lang.Boolean))(
        _.isAttached
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.StaticIp.ReadOnly =
    zio.aws.lightsail.model.StaticIp.wrap(buildAwsValue())
}
object StaticIp {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.StaticIp
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.StaticIp =
      zio.aws.lightsail.model.StaticIp(
        name.map(value => value),
        arn.map(value => value),
        supportCode.map(value => value),
        createdAt.map(value => value),
        location.map(value => value.asEditable),
        resourceType.map(value => value),
        ipAddress.map(value => value),
        attachedTo.map(value => value),
        isAttached.map(value => value)
      )
    def name: Option[ResourceName]
    def arn: Option[NonEmptyString]
    def supportCode: Option[String]
    def createdAt: Option[IsoDate]
    def location: Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly]
    def resourceType: Option[zio.aws.lightsail.model.ResourceType]
    def ipAddress: Option[IpAddress]
    def attachedTo: Option[ResourceName]
    def isAttached: Option[Boolean]
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getSupportCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("supportCode", supportCode)
    def getCreatedAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.lightsail.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getAttachedTo: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("attachedTo", attachedTo)
    def getIsAttached: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isAttached", isAttached)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.StaticIp
  ) extends zio.aws.lightsail.model.StaticIp.ReadOnly {
    override val name: Option[ResourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val arn: Option[NonEmptyString] = scala
      .Option(impl.arn())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val supportCode: Option[String] =
      scala.Option(impl.supportCode()).map(value => value: String)
    override val createdAt: Option[IsoDate] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.lightsail.model.primitives.IsoDate(value))
    override val location
        : Option[zio.aws.lightsail.model.ResourceLocation.ReadOnly] = scala
      .Option(impl.location())
      .map(value => zio.aws.lightsail.model.ResourceLocation.wrap(value))
    override val resourceType: Option[zio.aws.lightsail.model.ResourceType] =
      scala
        .Option(impl.resourceType())
        .map(value => zio.aws.lightsail.model.ResourceType.wrap(value))
    override val ipAddress: Option[IpAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.lightsail.model.primitives.IpAddress(value))
    override val attachedTo: Option[ResourceName] = scala
      .Option(impl.attachedTo())
      .map(value => zio.aws.lightsail.model.primitives.ResourceName(value))
    override val isAttached: Option[Boolean] =
      scala.Option(impl.isAttached()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.StaticIp
  ): zio.aws.lightsail.model.StaticIp.ReadOnly = new Wrapper(impl)
}
