package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{ResourceArn, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceName: ResourceName,
    resourceArn: Option[ResourceArn] = None,
    tags: Iterable[zio.aws.lightsail.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.TagResourceRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.TagResourceRequest.ReadOnly =
    zio.aws.lightsail.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.TagResourceRequest =
      zio.aws.lightsail.model.TagResourceRequest(
        resourceName,
        resourceArn.map(value => value),
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceName: ResourceName
    def resourceArn: Option[ResourceArn]
    def tags: List[zio.aws.lightsail.model.Tag.ReadOnly]
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.lightsail.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.TagResourceRequest
  ) extends zio.aws.lightsail.model.TagResourceRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.lightsail.model.primitives.ResourceArn(value))
    override val tags: List[zio.aws.lightsail.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.lightsail.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.TagResourceRequest
  ): zio.aws.lightsail.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
