package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestAlarmRequest(
    alarmName: ResourceName,
    state: zio.aws.lightsail.model.AlarmState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.TestAlarmRequest = {
    import TestAlarmRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.TestAlarmRequest
      .builder()
      .alarmName(ResourceName.unwrap(alarmName): java.lang.String)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.TestAlarmRequest.ReadOnly =
    zio.aws.lightsail.model.TestAlarmRequest.wrap(buildAwsValue())
}
object TestAlarmRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.TestAlarmRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.TestAlarmRequest =
      zio.aws.lightsail.model.TestAlarmRequest(alarmName, state)
    def alarmName: ResourceName
    def state: zio.aws.lightsail.model.AlarmState
    def getAlarmName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(alarmName)
    def getState: ZIO[Any, Nothing, zio.aws.lightsail.model.AlarmState] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.TestAlarmRequest
  ) extends zio.aws.lightsail.model.TestAlarmRequest.ReadOnly {
    override val alarmName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.alarmName())
    override val state: zio.aws.lightsail.model.AlarmState =
      zio.aws.lightsail.model.AlarmState.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.TestAlarmRequest
  ): zio.aws.lightsail.model.TestAlarmRequest.ReadOnly = new Wrapper(impl)
}
