package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{TagKey, ResourceArn, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceName: ResourceName,
    resourceArn: Option[ResourceArn] = None,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UntagResourceRequest
      .builder()
      .resourceName(ResourceName.unwrap(resourceName): java.lang.String)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.UntagResourceRequest.ReadOnly =
    zio.aws.lightsail.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UntagResourceRequest =
      zio.aws.lightsail.model.UntagResourceRequest(
        resourceName,
        resourceArn.map(value => value),
        tagKeys
      )
    def resourceName: ResourceName
    def resourceArn: Option[ResourceArn]
    def tagKeys: List[TagKey]
    def getResourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceName)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UntagResourceRequest
  ) extends zio.aws.lightsail.model.UntagResourceRequest.ReadOnly {
    override val resourceName: ResourceName =
      zio.aws.lightsail.model.primitives.ResourceName(impl.resourceName())
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.lightsail.model.primitives.ResourceArn(value))
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.lightsail.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UntagResourceRequest
  ): zio.aws.lightsail.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
