package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{NonEmptyString, BucketName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateBucketBundleRequest(
    bucketName: BucketName,
    bundleId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest = {
    import UpdateBucketBundleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .bundleId(NonEmptyString.unwrap(bundleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.UpdateBucketBundleRequest.ReadOnly =
    zio.aws.lightsail.model.UpdateBucketBundleRequest.wrap(buildAwsValue())
}
object UpdateBucketBundleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateBucketBundleRequest =
      zio.aws.lightsail.model.UpdateBucketBundleRequest(bucketName, bundleId)
    def bucketName: BucketName
    def bundleId: NonEmptyString
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getBundleId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(bundleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest
  ) extends zio.aws.lightsail.model.UpdateBucketBundleRequest.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.lightsail.model.primitives.BucketName(impl.bucketName())
    override val bundleId: NonEmptyString =
      zio.aws.lightsail.model.primitives.NonEmptyString(impl.bundleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketBundleRequest
  ): zio.aws.lightsail.model.UpdateBucketBundleRequest.ReadOnly = new Wrapper(
    impl
  )
}
