package zio.aws.lightsail.model
import zio.aws.lightsail.model.primitives.{NonEmptyString, BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateBucketRequest(
    bucketName: BucketName,
    accessRules: Option[zio.aws.lightsail.model.AccessRules] = None,
    versioning: Option[NonEmptyString] = None,
    readonlyAccessAccounts: Option[Iterable[NonEmptyString]] = None,
    accessLogConfig: Option[zio.aws.lightsail.model.BucketAccessLogConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest = {
    import UpdateBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(accessRules.map(value => value.buildAwsValue()))(
        _.accessRules
      )
      .optionallyWith(
        versioning.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.versioning)
      .optionallyWith(
        readonlyAccessAccounts.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.readonlyAccessAccounts)
      .optionallyWith(accessLogConfig.map(value => value.buildAwsValue()))(
        _.accessLogConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.lightsail.model.UpdateBucketRequest.ReadOnly =
    zio.aws.lightsail.model.UpdateBucketRequest.wrap(buildAwsValue())
}
object UpdateBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.lightsail.model.UpdateBucketRequest =
      zio.aws.lightsail.model.UpdateBucketRequest(
        bucketName,
        accessRules.map(value => value.asEditable),
        versioning.map(value => value),
        readonlyAccessAccounts.map(value => value),
        accessLogConfig.map(value => value.asEditable)
      )
    def bucketName: BucketName
    def accessRules: Option[zio.aws.lightsail.model.AccessRules.ReadOnly]
    def versioning: Option[NonEmptyString]
    def readonlyAccessAccounts: Option[List[NonEmptyString]]
    def accessLogConfig
        : Option[zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly]
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
    def getAccessRules
        : ZIO[Any, AwsError, zio.aws.lightsail.model.AccessRules.ReadOnly] =
      AwsError.unwrapOptionField("accessRules", accessRules)
    def getVersioning: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("versioning", versioning)
    def getReadonlyAccessAccounts: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "readonlyAccessAccounts",
        readonlyAccessAccounts
      )
    def getAccessLogConfig: ZIO[
      Any,
      AwsError,
      zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly
    ] = AwsError.unwrapOptionField("accessLogConfig", accessLogConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest
  ) extends zio.aws.lightsail.model.UpdateBucketRequest.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.lightsail.model.primitives.BucketName(impl.bucketName())
    override val accessRules
        : Option[zio.aws.lightsail.model.AccessRules.ReadOnly] = scala
      .Option(impl.accessRules())
      .map(value => zio.aws.lightsail.model.AccessRules.wrap(value))
    override val versioning: Option[NonEmptyString] = scala
      .Option(impl.versioning())
      .map(value => zio.aws.lightsail.model.primitives.NonEmptyString(value))
    override val readonlyAccessAccounts: Option[List[NonEmptyString]] = scala
      .Option(impl.readonlyAccessAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.lightsail.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val accessLogConfig
        : Option[zio.aws.lightsail.model.BucketAccessLogConfig.ReadOnly] = scala
      .Option(impl.accessLogConfig())
      .map(value => zio.aws.lightsail.model.BucketAccessLogConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.UpdateBucketRequest
  ): zio.aws.lightsail.model.UpdateBucketRequest.ReadOnly = new Wrapper(impl)
}
